<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>IoT Irrigation System</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="bg-gray-100">
    <!-- Navigation -->
    <nav class="bg-blue-600 text-white shadow-lg">
        <div class="container mx-auto px-4">
            <div class="flex justify-between items-center h-16">
                <div class="flex items-center">
                    <i class="fas fa-tint text-2xl mr-3"></i>
                    <h1 class="text-xl font-bold">IoT Irrigation System</h1>
                </div>
                <div class="flex space-x-4">
                    <a href="<?php echo e(route('dashboard')); ?>" 
                       class="hover:bg-blue-700 px-3 py-2 rounded <?php echo e(request()->routeIs('dashboard') ? 'bg-blue-800' : ''); ?>">
                        <i class="fas fa-home mr-2"></i>Dashboard
                    </a>
                    <a href="<?php echo e(route('motor.index')); ?>" 
                       class="hover:bg-blue-700 px-3 py-2 rounded <?php echo e(request()->routeIs('motor.*') ? 'bg-blue-800' : ''); ?>">
                        <i class="fas fa-cog mr-2"></i>Motor Control
                    </a>
                    <a href="<?php echo e(route('sensors.index')); ?>" 
                       class="hover:bg-blue-700 px-3 py-2 rounded <?php echo e(request()->routeIs('sensors.*') ? 'bg-blue-800' : ''); ?>">
                        <i class="fas fa-microchip mr-2"></i>Sensors
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="container mx-auto px-4 py-8">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Footer -->
    <footer class="bg-gray-800 text-white py-4 mt-8">
        <div class="container mx-auto px-4 text-center">
            <p>IoT Irrigation System &copy; <?php echo e(date('Y')); ?></p>
            <p class="text-sm text-gray-400 mt-1">ESP32 Based Smart Irrigation</p>
        </div>
    </footer>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH C:\xampp\htdocs\SmartIrrigation\resources\views/layouts/app.blade.php ENDPATH**/ ?>