

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto">
    <div class="bg-white rounded-xl shadow-lg overflow-hidden">
        <!-- Header -->
        <div class="bg-gradient-to-r from-blue-500 to-blue-600 px-6 py-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-white">
                        <i class="fas fa-cog mr-3"></i>Water Pump Control
                    </h1>
                    <p class="text-blue-100 mt-2">Manually control your irrigation water pump</p>
                </div>
                <div class="bg-white bg-opacity-20 p-3 rounded-full">
                    <i class="fas fa-water text-3xl text-white"></i>
                </div>
            </div>
        </div>

        <!-- Control Panel -->
        <div class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Status Display -->
                <div class="bg-gray-50 rounded-lg p-6">
                    <h3 class="text-lg font-semibold text-gray-800 mb-4">
                        <i class="fas fa-info-circle text-blue-500 mr-2"></i>Current Status
                    </h3>
                    
                    <div class="space-y-4">
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">Pump Status:</span>
                            <span id="status-indicator" class="px-4 py-2 rounded-full font-semibold
                                <?php echo e($motor->status == 'on' ? 'bg-green-100 text-green-800 animate-pulse' : 'bg-gray-200 text-gray-800'); ?>">
                                <?php echo e(strtoupper($motor->status)); ?>

                            </span>
                        </div>
                        
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">Last Activated:</span>
                            <span id="last-activated-time" class="font-medium">
                                <?php echo e($motor->last_activated_at ? $motor->last_activated_at->format('Y-m-d H:i:s') : 'Never'); ?>

                            </span>
                        </div>
                        
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">Current Time:</span>
                            <span id="current-time" class="font-medium"><?php echo e(now()->format('Y-m-d H:i:s')); ?></span>
                        </div>
                    </div>
                </div>

                <!-- Control Buttons -->
                <div class="bg-gray-50 rounded-lg p-6">
                    <h3 class="text-lg font-semibold text-gray-800 mb-4">
                        <i class="fas fa-gamepad text-blue-500 mr-2"></i>Manual Control
                    </h3>
                    
                    <div class="space-y-4">
                        <button id="btn-turn-on" 
                            class="w-full py-4 rounded-lg font-bold text-lg transition duration-300 
                                <?php echo e($motor->status == 'on' ? 'bg-gray-300 cursor-not-allowed' : 'bg-green-500 hover:bg-green-600'); ?> 
                                text-white flex items-center justify-center">
                            <i class="fas fa-play-circle mr-3"></i>
                            TURN PUMP ON
                        </button>
                        
                        <button id="btn-turn-off" 
                            class="w-full py-4 rounded-lg font-bold text-lg transition duration-300 
                                <?php echo e($motor->status == 'off' ? 'bg-gray-300 cursor-not-allowed' : 'bg-red-500 hover:bg-red-600'); ?> 
                                text-white flex items-center justify-center">
                            <i class="fas fa-stop-circle mr-3"></i>
                            TURN PUMP OFF
                        </button>
                        
                        <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mt-4">
                            <h4 class="font-semibold text-blue-800 mb-2">
                                <i class="fas fa-lightbulb text-yellow-500 mr-2"></i>Tip
                            </h4>
                            <p class="text-sm text-blue-700">
                                The pump will automatically turn off after 30 minutes to prevent over-watering.
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Activity Log (Optional) -->
            <div class="mt-8">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">
                    <i class="fas fa-history text-blue-500 mr-2"></i>Recent Activity
                </h3>
                <div class="bg-gray-50 rounded-lg p-4">
                    <div id="activity-log" class="text-gray-600">
                        <p class="mb-2">• System initialized</p>
                        <?php if($motor->last_activated_at): ?>
                            <p>• Pump last activated at <?php echo e($motor->last_activated_at->format('Y-m-d H:i:s')); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Update current time every second
    function updateCurrentTime() {
        const now = new Date();
        $('#current-time').text(now.toISOString().slice(0, 19).replace('T', ' '));
    }
    setInterval(updateCurrentTime, 1000);

    // Turn pump on
    $('#btn-turn-on').click(function() {
        if ($(this).hasClass('cursor-not-allowed')) return;
        
        $.ajax({
            url: "<?php echo e(route('motor.update')); ?>",
            method: 'POST',
            data: {
                _token: "<?php echo e(csrf_token()); ?>",
                status: 'on'
            },
            success: function(response) {
                updateMotorStatus('on');
                addActivityLog('Pump turned ON manually');
            }
        });
    });

    // Turn pump off
    $('#btn-turn-off').click(function() {
        if ($(this).hasClass('cursor-not-allowed')) return;
        
        $.ajax({
            url: "<?php echo e(route('motor.update')); ?>",
            method: 'POST',
            data: {
                _token: "<?php echo e(csrf_token()); ?>",
                status: 'off'
            },
            success: function(response) {
                updateMotorStatus('off');
                addActivityLog('Pump turned OFF manually');
            }
        });
    });

    function updateMotorStatus(status) {
        // Update status indicator
        $('#status-indicator').text(status.toUpperCase());
        if (status === 'on') {
            $('#status-indicator').removeClass('bg-gray-200 text-gray-800')
                .addClass('bg-green-100 text-green-800 animate-pulse');
            $('#btn-turn-on').addClass('bg-gray-300 cursor-not-allowed')
                .removeClass('bg-green-500 hover:bg-green-600');
            $('#btn-turn-off').removeClass('bg-gray-300 cursor-not-allowed')
                .addClass('bg-red-500 hover:bg-red-600');
        } else {
            $('#status-indicator').removeClass('bg-green-100 text-green-800 animate-pulse')
                .addClass('bg-gray-200 text-gray-800');
            $('#btn-turn-on').removeClass('bg-gray-300 cursor-not-allowed')
                .addClass('bg-green-500 hover:bg-green-600');
            $('#btn-turn-off').addClass('bg-gray-300 cursor-not-allowed')
                .removeClass('bg-red-500 hover:bg-red-600');
        }
        
        // Update last activated time
        $.get("<?php echo e(route('motor.status')); ?>", function(data) {
            if (data.last_activated_at) {
                const date = new Date(data.last_activated_at);
                $('#last-activated-time').text(date.toISOString().slice(0, 19).replace('T', ' '));
            }
        });
    }

    function addActivityLog(message) {
        const now = new Date();
        const timeString = now.toLocaleTimeString();
        $('#activity-log').prepend(`<p class="mb-2">• ${message} at ${timeString}</p>`);
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\SmartIrrigation\resources\views/motor/index.blade.php ENDPATH**/ ?>