<?php

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\MotorCOntrollController;
use App\Http\Controllers\MotorController;
use App\Http\Controllers\SensorController;
use App\Http\Controllers\SensorDataController;
use Illuminate\Support\Facades\Route;

Route::get('/', [DashboardController::class, 'index'])->name('dashboard');

Route::prefix('motor')->group(function () {
    Route::get('/', [MotorCOntrollController::class, 'index'])->name('motor.index');
    Route::post('/update', [MotorCOntrollController::class, 'update'])->name('motor.update');
    Route::get('/status', [MotorCOntrollController::class, 'getStatus'])->name('motor.status');
});

Route::prefix('sensors')->group(function () {
    Route::get('/', [SensorDataController::class, 'index'])->name('sensors.index');
    Route::post('/store', [SensorDataController::class, 'store'])->name('sensors.store');
    Route::get('/latest', [SensorDataController::class, 'getLatest'])->name('sensors.latest');
});