<?php

namespace App\Http\Controllers;

use App\Models\SensorData;
use Illuminate\Http\Request;
use Aimedidierm\FdiSms\SendSms;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;

class SensorDataController extends Controller
{
    /**
     * Display a listing of the resource.
     */
     public function index()
    {
        $sensorData = SensorData::latest()->take(50)->get();
        $latestData = SensorData::latest()->first();
        
        return view('sensors.index', compact('sensorData', 'latestData'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'temperature' => 'required|numeric',
            'humidity' => 'required|numeric|between:0,100',
            'soil_moisture' => 'required|integer|between:0,1023'
        ]);
        
        $sensorData = SensorData::create($request->all());

        return response()->json([
            'success' => true,
            'data' => $sensorData
        ]);
    }

    public function getLatest()
    {
        $latestData = SensorData::latest()->first();
        
        return response()->json([
            'temperature' => $latestData->temperature ?? 0,
            'humidity' => $latestData->humidity ?? 0,
            'soil_moisture' => $latestData->soil_moisture ?? 0,
            'updated_at' => $latestData->updated_at ?? now()
        ]);
    }

        public function sendSmsToUser($to, $message)
{
    try {
        $senderId = "FDI";
        $ref = Str::random(40);
        $callbackUrl = "";

        // Send SMS
        $apiUsername = env("SMS_USERNAME");
        $apiPassword = env("SMS_PASSWORD");
        $smsSender = new SendSms($apiUsername, $apiPassword);

        $response = $smsSender->sendSms($to, $message, $senderId, $ref, $callbackUrl);

        // Optional: Log the SMS sending response
        Log::info('SMS Sent', [
            'to' => $to,
            'message' => $message,
            'response' => $response
        ]);

        return $response;
    } catch (\Exception $e) {
        // Log any errors that occur during SMS sending
        Log::error('SMS Sending Failed', [
            'to' => $to,
            'message' => $message,
            'error' => $e->getMessage()
        ]);

        return false;
    }
}


}


 //        // ✅ Send SMS notification
        // $member = $loan->member;
        // $to = $member->user->phone;
        // $message = "Dear " . $member->name . ", your loan of " . 
        //            number_format($loan->amount, 2) . " RWF has been marked as PAID. " .
        //            "Total repaid: " . number_format($totalAmount, 2) . " RWF. Thank you!";
        
        // $this->sendSmsToUser($to, $message);
        