<?php

namespace App\Http\Controllers;

use App\Models\MotorCOntroll;
use Illuminate\Http\Request;

class MotorCOntrollController extends Controller
{
    /**
     * Display a listing of the resource.
     */
 public function index()
    {
        $motor = MotorCOntroll::first();
        
        // If no motor record exists, create one
        if (!$motor) {
            $motor = MotorCOntroll::create(['status' => 'off']);
        }
        
        return view('motor.index', compact('motor'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'status' => 'required|in:on,off'
        ]);
        
        $motor = MotorCOntroll::first();
        
        if ($request->status == 'on') {
            $motor->update([
                'status' => 'on',
                'last_activated_at' => now()
            ]);
        } else {
            $motor->update(['status' => 'off']);
        }
        
        return response()->json([
            'success' => true,
            'status' => $motor->status,
            'last_activated' => $motor->last_activated_at
        ]);
    }

    public function getStatus()
    {
        $motor = MotorCOntroll::first();
        
        return response()->json([
            'status' => $motor->status,
            'last_activated_at' => $motor->last_activated_at
        ]);
    }
    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(MotorCOntroll $motorCOntroll)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(MotorCOntroll $motorCOntroll)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
   

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(MotorCOntroll $motorCOntroll)
    {
        //
    }
}
